<?php
// Router for PHP built-in server

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// If requesting admin_api.php, execute it
if ($uri === '/admin_api.php') {
    require __DIR__ . '/admin_api.php';
    exit;
}

// If file exists, serve it
if ($uri !== '/' && file_exists(__DIR__ . $uri)) {
    return false; // Let PHP's built-in server handle it
}

// For directory requests, check for index.html or index.php
if (is_dir(__DIR__ . $uri)) {
    if (file_exists(__DIR__ . $uri . '/index.html')) {
        require __DIR__ . $uri . '/index.html';
        exit;
    }
    if (file_exists(__DIR__ . $uri . '/index.php')) {
        require __DIR__ . $uri . '/index.php';
        exit;
    }
}

// Default: return false to let built-in server handle
return false;
