<?php
/**
 * ربات آپلودر تلگرام
 * Telegram Uploader Bot - Main File
 * 
 * @version 1.0
 * @author Your Name
 */

// تنظیمات خطا
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// بارگذاری فایل‌های مورد نیاز
require_once 'config.php';
require_once 'includes/database.php';
require_once 'includes/telegram.php';
require_once 'includes/htmlparser.php';
require_once 'includes/uploader.php';
require_once 'handlers/start.php';
require_once 'handlers/upload.php';
require_once 'handlers/admin.php';
require_once 'handlers/advanced_upload.php';
require_once 'handlers/user.php';

// دریافت آپدیت از تلگرام
if (isset($GLOBALS['mockInputData'])) {
    // حالت تست (polling mode)
    $content = $GLOBALS['mockInputData'];
} else {
    // حالت عادی (webhook mode)
    $content = file_get_contents('php://input');
}
$update = json_decode($content, true);

// لاگ آپدیت‌ها (اختیاری - برای دیباگ)
// file_put_contents('updates.log', $content . "\n\n", FILE_APPEND);

// بررسی وجود آپدیت
if (!$update) {
    exit;
}

// پردازش پیام
if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $userId = $message['from']['id'];
    $firstName = $message['from']['first_name'] ?? '';
    $lastName = $message['from']['last_name'] ?? '';
    $username = $message['from']['username'] ?? '';
    
    // بررسی حالت تعمیر و نگهداری (فقط برای غیرادمین)
    $settings = Database::getSettings();
    if ($settings['maintenance_mode'] && !Telegram::isAdmin($userId)) {
        $maintenanceMsg = "🔧 " . HTMLParser::format("ربات در حال تعمیر و نگهداری است", true) . "\n\n";
        $maintenanceMsg .= HTMLParser::blockquote("لطفاً بعداً مراجعه کنید");
        Telegram::sendMessage($chatId, $maintenanceMsg);
        exit;
    }
    
    // دستور start
    if (isset($message['text'])) {
        $text = $message['text'];
        
        // بررسی state برای ادامه فرآیند آپلود
        $uploadState = Database::getUploadState($userId);
        
        if ($uploadState && Telegram::isAdmin($userId)) {
            if ($uploadState['state'] == 'awaiting_title') {
                // دریافت تایتل
                $fileData = $uploadState['data'];
                $fileData['title'] = $text;
                Database::setUploadState($userId, 'awaiting_settings', $fileData);
                
                showFileSettings($chatId, $userId);
                exit;
                
            } elseif ($uploadState['state'] == 'awaiting_caption') {
                // دریافت کپشن
                $fileData = $uploadState['data'];
                $fileData['caption'] = $text;
                Database::setUploadState($userId, 'awaiting_settings', $fileData);
                
                showFileSettings($chatId, $userId);
                exit;
                
            } elseif ($uploadState['state'] == 'awaiting_password') {
                // دریافت رمز عبور
                $fileData = $uploadState['data'];
                
                if ($text == '0') {
                    // حذف رمز
                    $fileData['password'] = '';
                    Telegram::sendMessage($chatId, "🔓 رمز عبور حذف شد.");
                } else {
                    $fileData['password'] = $text;
                    Telegram::sendMessage($chatId, "✅ رمز عبور تنظیم شد: " . HTMLParser::format($text, false, false, true));
                }
                
                Database::setUploadState($userId, 'awaiting_settings', $fileData);
                showFileSettings($chatId, $userId);
                exit;
                
            } elseif ($uploadState['state'] == 'awaiting_limit') {
                // دریافت محدودیت دانلود
                if (is_numeric($text) && $text >= 0) {
                    $fileData = $uploadState['data'];
                    $fileData['download_limit'] = intval($text);
                    Database::setUploadState($userId, 'awaiting_settings', $fileData);
                    
                    showFileSettings($chatId, $userId);
                } else {
                    Telegram::sendMessage($chatId, "❌ لطفاً یک عدد معتبر وارد کنید!");
                }
                exit;
                
            } elseif ($uploadState['state'] == 'awaiting_expire') {
                // دریافت تاریخ انقضا
                if (is_numeric($text) && $text >= 0) {
                    $fileData = $uploadState['data'];
                    $fileData['expire_days'] = intval($text);
                    Database::setUploadState($userId, 'awaiting_settings', $fileData);
                    
                    showFileSettings($chatId, $userId);
                } else {
                    Telegram::sendMessage($chatId, "❌ لطفاً یک عدد معتبر وارد کنید!");
                }
                exit;
                
            } elseif ($uploadState['state'] == 'awaiting_link') {
                // دریافت لینک دانلود
                if (filter_var($text, FILTER_VALIDATE_URL)) {
                    handleUploadFromUrl($chatId, $userId, $text);
                } else {
                    Telegram::sendMessage($chatId, "❌ لینک نامعتبر است! لطفاً یک URL معتبر وارد کنید.");
                }
                exit;
            } elseif ($uploadState['state'] == 'awaiting_user_search') {
                // جستجوی کاربر
                handleUserSearch($chatId, $text);
                exit;
            } elseif ($uploadState['state'] == 'awaiting_notification_channel') {
                // تنظیم کانال اطلاع‌رسانی
                handleSetNotificationChannel($chatId, $text);
                exit;
            } elseif ($uploadState['state'] == 'awaiting_broadcast_message') {
                // دریافت پیام برای broadcast
                sendBroadcast($chatId, $userId, $message);
                exit;
            } elseif ($uploadState['state'] == 'awaiting_add_admin') {
                // دریافت User ID برای افزودن ادمین
                handleAddAdmin($chatId, $userId, $text);
                exit;
            } elseif ($uploadState['state'] == 'awaiting_remove_admin') {
                // دریافت User ID برای حذف ادمین
                handleRemoveAdmin($chatId, $userId, $text);
                exit;
            } elseif ($uploadState['state'] == 'awaiting_warning_info') {
                // دریافت اطلاعات برای ارسال اخطار
                $parts = explode(' ', $text, 2);
                if (count($parts) >= 2) {
                    handleSendWarning($chatId, $userId, $parts[0], $parts[1]);
                } else {
                    Telegram::sendMessage($chatId, "❌ فرمت صحیح: <user_id> <دلیل>");
                }
                exit;
            } elseif ($uploadState['state'] == 'awaiting_view_warnings') {
                // دریافت User ID برای مشاهده اخطارها
                handleViewWarnings($chatId, $text);
                Database::clearUploadState($userId);
                exit;
            } elseif ($uploadState['state'] == 'awaiting_clear_warnings') {
                // دریافت User ID برای پاک کردن اخطارها
                handleClearWarnings($chatId, $text);
                Database::clearUploadState($userId);
                exit;
            }
        }
        
        // بررسی رمز عبور فایل (برای کاربران عادی)
        $passwordAttempt = Database::getPasswordAttempt($userId);
        if ($passwordAttempt) {
            $fileId = $passwordAttempt['file_id'];
            
            if (Database::checkFilePassword($fileId, $text)) {
                // رمز درست است
                Database::clearPasswordAttempt($userId);
                
                Telegram::sendMessage($chatId, "✅ رمز صحیح است!");
                
                // نمایش پیشنمایش فایل
                handleStartWithParameter($chatId, $userId, $firstName, $fileId);
            } else {
                // رمز اشتباه است
                $message = "❌ " . HTMLParser::format("رمز اشتباه است!", true) . "\n\n";
                $message .= HTMLParser::blockquote("لطفاً رمز صحیح را وارد کنید");
                $message .= "\n\nبرای لغو: /cancel";
                
                Telegram::sendMessage($chatId, $message);
            }
            exit;
        }
        
        // دستور /start
        if (strpos($text, '/start') === 0) {
            $parts = explode(' ', $text, 2);
            
            if (count($parts) > 1) {
                // استارت با پارامتر (دانلود فایل)
                $parameter = trim($parts[1]);
                handleStartWithParameter($chatId, $userId, $firstName, $parameter);
            } else {
                // استارت ساده
                handleStart($chatId, $firstName, $userId, $username, $lastName);
                
                // نمایش پنل ادمین برای ادمین
                if (Telegram::isAdmin($userId)) {
                    showAdminPanel($chatId);
                }
            }
        }
        // دستور /cancel - لغو عملیات جاری
        elseif ($text == '/cancel') {
            Database::clearUploadState($userId);
            Database::clearPasswordAttempt($userId);
            
            $message = "❌ عملیات لغو شد.";
            
            if (Telegram::isAdmin($userId)) {
                Telegram::sendMessage($chatId, $message, Telegram::getAdminKeyboard());
            } else {
                Telegram::sendMessage($chatId, $message, Telegram::getUserKeyboard());
            }
        }
        // دستورات پنل کاربران عادی
        elseif ($text == '👤 اطلاعات من') {
            $settings = Database::getSettings();
            if (!isset($settings['user_button_info']) || $settings['user_button_info']) {
                handleUserInfo($chatId, $userId);
            } else {
                Telegram::sendMessage($chatId, "⚠️ این بخش غیرفعال شده است.", Telegram::getUserKeyboard());
            }
        }
        elseif ($text == '📥 فایل‌های دانلود شده') {
            $settings = Database::getSettings();
            if (!isset($settings['user_button_downloads']) || $settings['user_button_downloads']) {
                handleUserDownloadedFiles($chatId, $userId);
            } else {
                Telegram::sendMessage($chatId, "⚠️ این بخش غیرفعال شده است.", Telegram::getUserKeyboard());
            }
        }
        elseif ($text == '⭐ بهترین فایل‌ها') {
            $settings = Database::getSettings();
            if (!isset($settings['user_button_toprated']) || $settings['user_button_toprated']) {
                handleTopRatedFiles($chatId);
            } else {
                Telegram::sendMessage($chatId, "⚠️ این بخش غیرفعال شده است.", Telegram::getUserKeyboard());
            }
        }
        // دستورات پنل ادمین
        elseif ($text == '📊 آمار کاربران' && Telegram::isAdmin($userId)) {
            handleStats($chatId);
        }
        elseif ($text == '� جستجوی کاربر' && Telegram::isAdmin($userId)) {
            handleSearchUserGuide($chatId);
        }
        elseif ($text == '�📁 فایل‌های من' && Telegram::isAdmin($userId)) {
            handleList($chatId, $userId);
        }
        elseif ($text == '📤 آپلود فایل' && Telegram::isAdmin($userId)) {
            showUploadMenu($chatId);
        }
        elseif ($text == '📎 آپلود از تلگرام' && Telegram::isAdmin($userId)) {
            handleTelegramUpload($chatId, $userId);
        }
        elseif ($text == '🔗 آپلود از لینک' && Telegram::isAdmin($userId)) {
            handleLinkUploadGuide($chatId, $userId);
        }
        elseif ($text == '🖥 وضعیت سرور' && Telegram::isAdmin($userId)) {
            handleServerStatus($chatId);
        }
        elseif ($text == '⚙️ تنظیمات' && Telegram::isAdmin($userId)) {
            handleSettings($chatId);
        }
        elseif ($text == '📋 راهنما' && Telegram::isAdmin($userId)) {
            handleAdminHelp($chatId);
        }
        elseif ($text == '🔙 بازگشت' && Telegram::isAdmin($userId)) {
            showAdminPanel($chatId);
        }
        // دکمه‌های تنظیمات
        elseif ((strpos($text, 'فعال کردن تعمیر') !== false || strpos($text, 'غیرفعال کردن تعمیر') !== false) && Telegram::isAdmin($userId)) {
            toggleMaintenance($chatId);
        }
        elseif ((strpos($text, 'فعال جوین اجباری') !== false || strpos($text, 'غیرفعال جوین اجباری') !== false) && Telegram::isAdmin($userId)) {
            toggleForceJoin($chatId);
        }
        elseif ($text == '🔗 تنظیم کانال الزامی' && Telegram::isAdmin($userId)) {
            $msg = "📢 " . HTMLParser::format("تنظیم کانال الزامی", true) . "\n\n";
            $msg .= "برای تنظیم کانال، از دستور زیر استفاده کنید:\n\n";
            $msg .= HTMLParser::format("/setchannel @channel_username", false, false, true) . "\n\n";
            $msg .= "مثال:\n";
            $msg .= HTMLParser::format("/setchannel @mychannel", false, false, true);
            Telegram::sendMessage($chatId, $msg, Telegram::getSettingsKeyboard());
        }
        // مدیریت کانال‌ها
        elseif ($text == '📢 مدیریت کانال‌ها' && Telegram::isAdmin($userId)) {
            handleChannelsMenu($chatId);
        }
        elseif ($text == '📋 لیست کانال‌ها' && Telegram::isAdmin($userId)) {
            handleChannelsList($chatId);
        }
        elseif ($text == '➕ افزودن کانال' && Telegram::isAdmin($userId)) {
            handleAddChannelGuide($chatId);
        }
        elseif ($text == '➖ حذف کانال' && Telegram::isAdmin($userId)) {
            handleRemoveChannelGuide($chatId);
        }
        elseif ($text == '🔙 بازگشت به تنظیمات' && Telegram::isAdmin($userId)) {
            handleSettings($chatId);
        }
        // مدیریت اطلاع‌رسانی
        elseif ($text == '🔔 اطلاع‌رسانی آپلود' && Telegram::isAdmin($userId)) {
            handleNotificationMenu($chatId);
        }
        elseif ((strpos($text, 'فعال کردن') !== false || strpos($text, 'غیرفعال کردن') !== false) && strpos($text, 'اطلاع') === false && Telegram::isAdmin($userId)) {
            // دکمه فعال/غیرفعال اطلاع‌رسانی
            if (strpos($text, '🔴') !== false || strpos($text, '🟢') !== false) {
                $uploadState = Database::getUploadState($userId);
                if (!$uploadState) {
                    toggleNotification($chatId);
                }
            }
        }
        elseif (strpos($text, 'ارسال به کاربران:') !== false && Telegram::isAdmin($userId)) {
            toggleNotificationToUsers($chatId);
        }
        elseif (strpos($text, 'ارسال به کانال:') !== false && Telegram::isAdmin($userId)) {
            toggleNotificationToChannel($chatId);
        }
        elseif ($text == '⚙️ تنظیم کانال' && Telegram::isAdmin($userId)) {
            handleSetNotificationChannelGuide($chatId);
        }
        // پیام همگانی
        elseif ($text == '📢 پیام همگانی' && Telegram::isAdmin($userId)) {
            handleBroadcast($chatId, $userId);
        }
        elseif ($text == '❌ لغو' && Telegram::isAdmin($userId)) {
            Database::clearUploadState($userId);
            Telegram::sendMessage($chatId, "❌ عملیات لغو شد.", Telegram::getAdminKeyboard());
        }
        // مدیریت ادمین‌ها
        elseif ($text == '👥 مدیریت ادمین‌ها' && $userId == ADMIN_ID) {
            handleAdminsMenu($chatId, $userId);
        }
        elseif ($text == '➕ افزودن ادمین' && $userId == ADMIN_ID) {
            handleAddAdminGuide($chatId, $userId);
        }
        elseif ($text == '➖ حذف ادمین' && $userId == ADMIN_ID) {
            handleRemoveAdminGuide($chatId, $userId);
        }
        elseif ($text == '📋 لیست ادمین‌ها' && $userId == ADMIN_ID) {
            handleAdminsMenu($chatId, $userId);
        }
        elseif (strpos($text, '/addadmin') === 0 && $userId == ADMIN_ID) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $newAdminId = trim($parts[1]);
                handleAddAdmin($chatId, $userId, $newAdminId);
            } else {
                handleAddAdminGuide($chatId, $userId);
            }
        }
        elseif (strpos($text, '/removeadmin') === 0 && $userId == ADMIN_ID) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $adminIdToRemove = trim($parts[1]);
                handleRemoveAdmin($chatId, $userId, $adminIdToRemove);
            } else {
                handleRemoveAdminGuide($chatId, $userId);
            }
        }
        // اخطار به کاربران
        elseif ($text == '⚠️ اخطار به کاربران' && Telegram::isAdmin($userId)) {
            handleWarningsMenu($chatId);
        }
        elseif ($text == '➕ اخطار جدید' && Telegram::isAdmin($userId)) {
            handleSendWarningGuide($chatId, $userId);
        }
        elseif ($text == '📋 مشاهده اخطارها' && Telegram::isAdmin($userId)) {
            handleViewWarningsGuide($chatId, $userId);
        }
        elseif ($text == '🧹 پاک کردن اخطارها' && Telegram::isAdmin($userId)) {
            handleClearWarningsGuide($chatId, $userId);
        }
        elseif (strpos($text, '/warn') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 3);
            if (count($parts) >= 3) {
                $targetUserId = trim($parts[1]);
                $reason = trim($parts[2]);
                handleSendWarning($chatId, $userId, $targetUserId, $reason);
            } else {
                $msg = "❌ فرمت صحیح:\n";
                $msg .= HTMLParser::format("/warn <user_id> <دلیل>", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        elseif (strpos($text, '/warnings') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $targetUserId = trim($parts[1]);
                handleViewWarnings($chatId, $targetUserId);
            } else {
                handleViewWarningsGuide($chatId, $userId);
            }
        }
        elseif (strpos($text, '/clearwarnings') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $targetUserId = trim($parts[1]);
                handleClearWarnings($chatId, $targetUserId);
            } else {
                handleClearWarningsGuide($chatId, $userId);
            }
        }
        // اعتراضات
        elseif ($text == '📋 اعتراضات' && Telegram::isAdmin($userId)) {
            handleAppeals($chatId);
        }
        // مدیریت دکمه‌های کاربران
        elseif ($text == '🎛 مدیریت دکمه‌های کاربران' && Telegram::isAdmin($userId)) {
            handleUserButtonsMenu($chatId);
        }
        elseif (strpos($text, '👤 اطلاعات من:') !== false && Telegram::isAdmin($userId)) {
            toggleUserButtonInfo($chatId);
        }
        elseif (strpos($text, '📥 فایل‌های دانلود شده:') !== false && Telegram::isAdmin($userId)) {
            toggleUserButtonDownloads($chatId);
        }
        elseif (strpos($text, '⭐ بهترین فایل‌ها:') !== false && Telegram::isAdmin($userId)) {
            toggleUserButtonTopRated($chatId);
        }
        // دستور /addchannel
        elseif (strpos($text, '/addchannel') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $channelUsername = trim($parts[1]);
                handleAddChannel($chatId, $channelUsername);
            } else {
                $msg = "❌ " . HTMLParser::format("فرمت صحیح:", true) . "\n";
                $msg .= HTMLParser::format("/addchannel @channel_username", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /removechannel
        elseif (strpos($text, '/removechannel') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $channelUsername = trim($parts[1]);
                handleRemoveChannel($chatId, $channelUsername);
            } else {
                $msg = "❌ " . HTMLParser::format("فرمت صحیح:", true) . "\n";
                $msg .= HTMLParser::format("/removechannel @channel_username", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /list برای ادمین
        elseif ($text == '/list' || $text == '/files') {
            handleList($chatId, $userId);
        }
        // دستور /panel برای نمایش پنل
        elseif ($text == '/panel' && Telegram::isAdmin($userId)) {
            showAdminPanel($chatId);
        }
        // دستور /setchannel برای تنظیم کانال
        elseif (strpos($text, '/setchannel') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $channelUsername = trim($parts[1]);
                
                // حذف @ اگر وجود داشت
                $channelUsername = ltrim($channelUsername, '@');
                
                // تنظیم کانال با ID (باید دستی وارد شود)
                setForceJoinChannel($chatId, '@' . $channelUsername, '@' . $channelUsername);
            } else {
                $msg = "❌ " . HTMLParser::format("فرمت صحیح:", true) . "\n";
                $msg .= HTMLParser::format("/setchannel @channel_username", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /broadcast برای ارسال پیام همگانی
        elseif (strpos($text, '/broadcast') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $broadcastMessage = trim($parts[1]);
                handleBroadcast($chatId, $broadcastMessage);
            } else {
                $msg = "❌ " . HTMLParser::format("فرمت صحیح:", true) . "\n";
                $msg .= HTMLParser::format("/broadcast پیام شما", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /uploadurl برای آپلود از لینک
        elseif (strpos($text, '/uploadurl') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $url = trim($parts[1]);
                handleUploadFromUrl($chatId, $userId, $url);
            } else {
                $msg = "📥 " . HTMLParser::format("آپلود از لینک", true) . "\n\n";
                $msg .= HTMLParser::blockquote("برای آپلود فایل از لینک مستقیم، از دستور زیر استفاده کنید");
                $msg .= "\n\n" . HTMLParser::format("/uploadurl [LINK]", false, false, true) . "\n\n";
                $msg .= "مثال:\n";
                $msg .= HTMLParser::format("/uploadurl https://example.com/file.zip", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /cancel برای لغو عملیات
        elseif ($text == '/cancel' && Telegram::isAdmin($userId)) {
            Database::clearUploadState($userId);
            Telegram::sendMessage($chatId, "✅ عملیات لغو شد.", Telegram::getAdminKeyboard());
        }
        // دستور /delete برای ادمین
        elseif (strpos($text, '/delete') === 0) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $uniqueId = trim($parts[1]);
                handleDelete($chatId, $userId, $uniqueId);
            } else {
                $msg = "❌ " . HTMLParser::format("فرمت صحیح:", true) . "\n";
                $msg .= HTMLParser::format("/delete <file_id>", false, false, true);
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /edit برای ویرایش فایل (ادمین)
        elseif (strpos($text, '/edit') === 0 && Telegram::isAdmin($userId)) {
            $parts = explode(' ', $text, 2);
            if (count($parts) > 1) {
                $fileId = trim($parts[1]);
                showFileManageMenu($chatId, $fileId);
            } else {
                $msg = "❌ " . HTMLParser::format("فرمت صحیح:", true) . "\n";
                $msg .= HTMLParser::format("/edit <file_id>", false, false, true) . "\n\n";
                $msg .= "مثال: /edit abc123";
                Telegram::sendMessage($chatId, $msg);
            }
        }
        // دستور /help
        elseif ($text == '/help' || $text == '/راهنما') {
            $helpMsg = "📚 " . HTMLParser::format("راهنمای ربات", true) . "\n\n";
            
            if (Telegram::isAdmin($userId)) {
                $helpMsg .= HTMLParser::blockquote("دستورات ادمین") . "\n\n";
                $helpMsg .= "🔹 برای آپلود فایل، فایل را ارسال کنید\n";
                $helpMsg .= "🔹 " . HTMLParser::format("/list", false, false, true) . " - مشاهده لیست فایل‌ها\n";
                $helpMsg .= "🔹 " . HTMLParser::format("/delete <id>", false, false, true) . " - حذف فایل\n";
                $helpMsg .= "🔹 " . HTMLParser::format("/help", false, false, true) . " - راهنما\n\n";
            } else {
                $helpMsg .= HTMLParser::blockquote("برای دانلود فایل، روی لینک ارسال شده کلیک کنید");
            }
            
            Telegram::sendMessage($chatId, $helpMsg);
        }
        // پیام عادی
        else {
            if (Telegram::isAdmin($userId)) {
                // بررسی اینکه آیا در حال پردازش مدیریت فایل است
                if (processFileManagementInput($chatId, $userId, $text)) {
                    // پردازش شد
                } else {
                    $msg = "برای آپلود فایل، فایل را ارسال کنید.\n";
                    $msg .= "برای مشاهده دستورات: /help";
                    Telegram::sendMessage($chatId, $msg);
                }
            } else {
                $msg = HTMLParser::blockquote("برای دانلود فایل، از لینک دریافتی استفاده کنید.");
                Telegram::sendMessage($chatId, $msg);
            }
        }
    }
    // دریافت فایل (فقط ادمین)
    elseif (
        isset($message['document']) ||
        isset($message['photo']) ||
        isset($message['video']) ||
        isset($message['audio']) ||
        isset($message['voice']) ||
        isset($message['animation'])
    ) {
        if (Telegram::isAdmin($userId)) {
            // بررسی state آپلود
            $uploadState = Database::getUploadState($userId);
            
            if ($uploadState && $uploadState['state'] == 'awaiting_telegram_file') {
                // آپلود از تلگرام در حال انجام
                handleUpload($chatId, $userId, $message);
            } else {
                // آپلود معمولی
                handleUpload($chatId, $userId, $message);
            }
        }
    }
}

// پردازش کالبک (اختیاری - برای آینده)
elseif (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];
    $chatId = $callbackQuery['message']['chat']['id'];
    $userId = $callbackQuery['from']['id'];
    $data = $callbackQuery['data'];
    $messageId = $callbackQuery['message']['message_id'];
    
    // دانلود فایل (بعد از تایید)
    if (strpos($data, 'download_file_') === 0) {
        $fileId = str_replace('download_file_', '', $data);
        
        // حذف پیام پیشنمایش
        Telegram::request('deleteMessage', [
            'chat_id' => $chatId,
            'message_id' => $messageId
        ]);
        
        // ارسال فایل
        sendFileToUser($chatId, $userId, $fileId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id'],
            'text' => '✅ در حال ارسال فایل...',
            'show_alert' => false
        ]);
    }
    // انصراف از دانلود
    elseif ($data == 'cancel_download') {
        Telegram::request('editMessageText', [
            'chat_id' => $chatId,
            'message_id' => $messageId,
            'text' => HTMLParser::blockquote('❌ دانلود لغو شد.'),
            'parse_mode' => 'HTML'
        ]);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id'],
            'text' => 'دانلود لغو شد',
            'show_alert' => false
        ]);
    }
    // بلاک کردن کاربر
    elseif (strpos($data, 'block_') === 0 && Telegram::isAdmin($userId)) {
        $targetUserId = str_replace('block_', '', $data);
        handleBlockUser($chatId, $targetUserId, $messageId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id'],
            'text' => '✅ کاربر بلاک شد',
            'show_alert' => false
        ]);
    }
    // آنبلاک کردن کاربر
    elseif (strpos($data, 'unblock_') === 0 && Telegram::isAdmin($userId)) {
        $targetUserId = str_replace('unblock_', '', $data);
        handleUnblockUser($chatId, $targetUserId, $messageId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id'],
            'text' => '✅ کاربر آنبلاک شد',
            'show_alert' => false
        ]);
    }
    // مشاهده فایل دانلود شده
    elseif (strpos($data, 'view_downloaded_') === 0) {
        $fileId = str_replace('view_downloaded_', '', $data);
        handleViewDownloadedFile($chatId, $userId, $fileId, $messageId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
    // دانلود مجدد فایل
    elseif (strpos($data, 'redownload_file_') === 0) {
        $fileId = str_replace('redownload_file_', '', $data);
        
        // حذف پیام پیشنمایش
        Telegram::request('deleteMessage', [
            'chat_id' => $chatId,
            'message_id' => $messageId
        ]);
        
        handleRedownloadFile($chatId, $userId, $fileId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id'],
            'text' => '✅ در حال ارسال فایل...',
            'show_alert' => false
        ]);
    }
    // بازگشت به لیست دانلودها
    elseif ($data == 'back_to_downloads') {
        // حذف پیام
        Telegram::request('deleteMessage', [
            'chat_id' => $chatId,
            'message_id' => $messageId
        ]);
        
        handleUserDownloadedFiles($chatId, $userId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
    // مدیریت فایل
    elseif (strpos($data, 'file_') === 0 && Telegram::isAdmin($userId)) {
        if (strpos($data, 'file_confirmdelete_') === 0) {
            $fileId = str_replace('file_confirmdelete_', '', $data);
            executeDeleteFile($chatId, $fileId, $messageId);
        } else {
            handleFileManageCallback($chatId, $userId, $data, $messageId);
        }
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
    // Callback برای بلاک کردن کاربر بعد از اخطارها
    elseif (strpos($data, 'block_user_') === 0) {
        $targetUserId = intval(str_replace('block_user_', '', $data));
        
        if (Telegram::isAdmin($userId)) {
            Database::blockUser($targetUserId);
            
            $user = Database::getUserById($targetUserId);
            $userName = $user['first_name'] ?? 'کاربر';
            
            Telegram::request('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $messageId,
                'text' => "🚫 کاربر " . HTMLParser::format($userName, true) . " با موفقیت بلاک شد!",
                'parse_mode' => 'HTML'
            ]);
            
            // اطلاع به کاربر
            $blockMsg = "🚫 " . HTMLParser::format("حساب شما مسدود شد!", true) . "\n\n";
            $blockMsg .= "به دلیل دریافت 3 اخطار، دسترسی شما به ربات " . HTMLParser::format("مسدود", true) . " شده است.";
            Telegram::sendMessage($targetUserId, $blockMsg, Telegram::removeKeyboard());
        }
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
    elseif ($data == 'ignore_warning') {
        if (Telegram::isAdmin($userId)) {
            Telegram::request('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $messageId,
                'text' => "✅ اخطار ثبت شد ولی کاربر بلاک نشد.",
                'parse_mode' => 'HTML'
            ]);
        }
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
    // امتیازدهی به فایل
    elseif (strpos($data, 'rate_') === 0) {
        $parts = explode('_', $data);
        if (count($parts) == 3) {
            $fileId = $parts[1];
            $rating = intval($parts[2]);
            
            handleRating($chatId, $userId, $fileId, $rating, $messageId);
            
            Telegram::request('answerCallbackQuery', [
                'callback_query_id' => $callbackQuery['id'],
                'text' => '✅ امتیاز ثبت شد: ' . $rating . ' ستاره',
                'show_alert' => false
            ]);
        }
    }
    // رد امتیازدهی
    elseif ($data == 'skip_rating') {
        Telegram::request('deleteMessage', [
            'chat_id' => $chatId,
            'message_id' => $messageId
        ]);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id'],
            'text' => 'می‌توانید بعداً امتیاز بدهید',
            'show_alert' => false
        ]);
    }
    // بررسی عضویت مجدد
    elseif (strpos($data, 'check_join_') === 0) {
        $fileId = str_replace('check_join_', '', $data);
        
        $settings = Database::getSettings();
        if ($settings['force_join']) {
            $channels = Database::getForceJoinChannels();
            $allJoined = true;
            $notJoinedChannels = [];
            
            // بررسی عضویت در تمام کانال‌ها
            foreach ($channels as $channel) {
                $isMember = Telegram::checkUserInChannel($userId, $channel['id']);
                
                if (!$isMember) {
                    $allJoined = false;
                    $notJoinedChannels[] = $channel['title'] ?: $channel['username'];
                }
            }
            
            if ($allJoined) {
                // کاربر در همه کانال‌ها عضو شده است
                Telegram::request('answerCallbackQuery', [
                    'callback_query_id' => $callbackQuery['id'],
                    'text' => '✅ عضویت شما در تمام کانال‌ها تایید شد!',
                    'show_alert' => false
                ]);
                
                // ارسال فایل
                $fileData = Database::getFile($fileId);
                if ($fileData) {
                    $firstName = $callbackQuery['from']['first_name'] ?? '';
                    handleStartWithParameter($chatId, $userId, $firstName, $fileId);
                }
            } else {
                // هنوز در همه کانال‌ها عضو نشده
                $notJoinedText = implode('، ', $notJoinedChannels);
                Telegram::request('answerCallbackQuery', [
                    'callback_query_id' => $callbackQuery['id'],
                    'text' => '❌ لطفاً ابتدا در تمام کانال‌ها عضو شوید: ' . $notJoinedText,
                    'show_alert' => true
                ]);
            }
        }
    }
    // کالبک‌های تنظیمات فایل
    elseif (Telegram::isAdmin($userId) && in_array($data, [
        'set_caption', 'set_limit', 'set_expire', 'toggle_force_join', 
        'preview_file', 'confirm_upload', 'cancel_upload'
    ])) {
        handleFileSettingsCallback($chatId, $userId, $data, $messageId);
        
        Telegram::request('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
}

// پایان
exit;
