<?php
/**
 * هندلر آپلود فایل توسط ادمین
 * Admin Upload Handler
 */

function handleUpload($chatId, $userId, $message) {
    // بررسی دسترسی ادمین
    if (!Telegram::isAdmin($userId)) {
        $errorMsg = "❌ " . HTMLParser::format("شما دسترسی ندارید!", true) . "\n\n";
        $errorMsg .= HTMLParser::blockquote("فقط ادمین می‌تواند فایل آپلود کند.");
        
        Telegram::sendMessage($chatId, $errorMsg);
        return;
    }
    
    $fileId = null;
    $fileName = null;
    $fileType = null;
    $fileSize = 0;
    
    // شناسایی نوع فایل
    if (isset($message['document'])) {
        $fileId = $message['document']['file_id'];
        $fileName = $message['document']['file_name'] ?? 'document';
        $fileType = 'document';
        $fileSize = $message['document']['file_size'] ?? 0;
        
    } elseif (isset($message['photo'])) {
        $photos = $message['photo'];
        $photo = end($photos); // بزرگترین سایز
        $fileId = $photo['file_id'];
        $fileName = 'photo_' . time() . '.jpg';
        $fileType = 'photo';
        $fileSize = $photo['file_size'] ?? 0;
        
    } elseif (isset($message['video'])) {
        $fileId = $message['video']['file_id'];
        $fileName = $message['video']['file_name'] ?? 'video_' . time() . '.mp4';
        $fileType = 'video';
        $fileSize = $message['video']['file_size'] ?? 0;
        
    } elseif (isset($message['audio'])) {
        $fileId = $message['audio']['file_id'];
        $fileName = $message['audio']['file_name'] ?? 'audio_' . time() . '.mp3';
        $fileType = 'audio';
        $fileSize = $message['audio']['file_size'] ?? 0;
        
    } elseif (isset($message['voice'])) {
        $fileId = $message['voice']['file_id'];
        $fileName = 'voice_' . time() . '.ogg';
        $fileType = 'voice';
        $fileSize = $message['voice']['file_size'] ?? 0;
        
    } elseif (isset($message['animation'])) {
        $fileId = $message['animation']['file_id'];
        $fileName = $message['animation']['file_name'] ?? 'animation_' . time() . '.gif';
        $fileType = 'animation';
        $fileSize = $message['animation']['file_size'] ?? 0;
        
    } else {
        $errorMsg = "❌ " . HTMLParser::format("نوع فایل پشتیبانی نمی‌شود!", true);
        Telegram::sendMessage($chatId, $errorMsg);
        return;
    }
    
    // بررسی حجم فایل
    if ($fileSize > MAX_FILE_SIZE) {
        $errorMsg = "❌ " . HTMLParser::format("حجم فایل بیش از حد مجاز است!", true) . "\n\n";
        $errorMsg .= "حداکثر حجم: " . HTMLParser::formatFileSize(MAX_FILE_SIZE);
        
        Telegram::sendMessage($chatId, $errorMsg);
        return;
    }
    
    // ذخیره موقت و انتقال به تنظیمات
    Database::setUploadState($userId, 'awaiting_settings', [
        'file_id' => $fileId,
        'file_name' => $fileName,
        'file_type' => $fileType,
        'file_size' => $fileSize,
        'title' => '',
        'caption' => '',
        'password' => '',
        'download_limit' => 0,
        'expire_days' => 0,
        'force_join_enabled' => true
    ]);
    
    $message = "✅ " . HTMLParser::format("فایل دریافت شد!", true) . "\n\n";
    $message .= "📁 نام: " . HTMLParser::format($fileName, false, false, true) . "\n";
    $message .= "💾 حجم: " . HTMLParser::format(HTMLParser::formatFileSize($fileSize)) . "\n\n";
    $message .= HTMLParser::blockquote("حالا تنظیمات فایل را مشخص کنید");
    
    Telegram::sendMessage($chatId, $message);
    
    // نمایش منوی تنظیمات
    showFileSettings($chatId, $userId);
}

/**
 * هندلر حذف فایل توسط ادمین
 */
function handleDelete($chatId, $userId, $uniqueId) {
    // بررسی دسترسی ادمین
    if (!Telegram::isAdmin($userId)) {
        $errorMsg = "❌ " . HTMLParser::format("شما دسترسی ندارید!", true);
        Telegram::sendMessage($chatId, $errorMsg);
        return;
    }
    
    // حذف فایل
    $result = Database::deleteFile($uniqueId);
    
    if ($result) {
        $successMsg = "✅ " . HTMLParser::format("فایل با موفقیت حذف شد!", true);
        Telegram::sendMessage($chatId, $successMsg);
    } else {
        $errorMsg = "❌ " . HTMLParser::format("فایل یافت نشد!", true);
        Telegram::sendMessage($chatId, $errorMsg);
    }
}

/**
 * هندلر لیست فایل‌ها برای ادمین
 */
function handleList($chatId, $userId) {
    // بررسی دسترسی ادمین
    if (!Telegram::isAdmin($userId)) {
        $errorMsg = "❌ " . HTMLParser::format("شما دسترسی ندارید!", true);
        Telegram::sendMessage($chatId, $errorMsg);
        return;
    }
    
    $files = Database::getAllFiles();
    
    if (empty($files)) {
        $message = "📂 " . HTMLParser::format("هیچ فایلی آپلود نشده است.", true);
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    $message = "📂 " . HTMLParser::format("لیست فایل‌های آپلود شده", true) . "\n";
    $message .= HTMLParser::format("تعداد: " . count($files)) . "\n\n";
    
    $counter = 1;
    foreach ($files as $file) {
        $message .= "{$counter}. " . HTMLParser::format($file['file_name'], false, false, true) . "\n";
        $message .= "   💾 " . HTMLParser::formatFileSize($file['file_size']) . "\n";
        $message .= "   📥 " . $file['download_count'] . " دانلود\n";
        $message .= "   🔑 ID: " . HTMLParser::format($file['id'], false, false, true) . "\n\n";
        
        $counter++;
        
        // جلوگیری از پیام خیلی طولانی
        if ($counter > 20) {
            $message .= "و " . (count($files) - 20) . " فایل دیگر...";
            break;
        }
    }
    
    Telegram::sendMessage($chatId, $message);
}
